#include <iostream>
#include <fstream>
#include <cstdlib>
#include <math.h>
#include <time.h>
#include <time.h>

using namespace std;

#define MAIN
#include "ldraw.hpp"

void pause(void)
{
	cout << "Press <Enter> to quit" << endl;
	getchar();
}
void usage(void)
{
	cout << "Selector [options] Infile Outfile" << endl;
	cout << "-p <val>: precision (default 0.001)" << endl;
	cout << "-k <val>: key color (default 5: dark Pink)" << endl;
	cout << "-c <val>: color for lines bordering key color (default: key color)" << endl;
	cout << "-b: don't select bordering lines"<< endl;
	cout << "-s: Sort key colored elements to the end of file" << endl;
	cout << "-d: Discolor key colored elements (-s Sort option required)" << endl;
	cout << "-d+: Discolor whole file (-s Sort option required)" << endl;
	cout << "-x-: Don't expand key color surface" << endl;
	cout << "-xl: Expand key color surface, edge line as frontier (default)" << endl;
	cout << "-x+: Expand key color surface on all neighbour surfaces" << endl;
	cout << "-a <val>: don't expand key color if angle between facets is > <val>" << endl;
	cout << "-m: don't limit expansion to main color surfaces" << endl;
	pause();
}

int main(int argc, char *argv[])
{
	printf("\nLdraw Selector 1.2 - by Philo");
	printf("\n-----------------------------\n");


	if(argc<3) 
	{
		usage();
		return 1;
	}

	LdPath* path=new LdPath();
	// Get input file path
	string curpath=argv[argc-2];
	size_t pathlen = curpath.find_last_of("\\");
	if(pathlen == string::npos) curpath = ".\\"; else curpath.resize(pathlen+1);
	path->addPath(curpath);
	string derivedpath=curpath;
	path->addPath(derivedpath.append("p\\"));
	derivedpath=curpath;
	path->addPath(derivedpath.append("s\\"));

	for(int i=1; i<argc-2; i++)
	{
		if(argv[i][0] != '-')
		{
			usage();
			return 1;
		}
		switch (argv[i][1])
		{
		case 'p':
			i++;
			sscanf(argv[i], "%lf",&LdPrecision);
			break;
		case 'k':
			i++;
			sscanf(argv[i], "%d",&KeyColor);
			break;
		case 's':
			Sorted=true;
			break;
		case 'b':
			NoBording=true;
			break;
		case 'x':
			switch (argv[i][2])
			{
			case '-':
				ExpandKey=false;
				break;
			case 'l':
				ExpandKey=true;
				NoFrontier=false;
				break;
			case '+':
				ExpandKey=true;
				NoFrontier=true;
				break;
			default:
				usage();
				return 1;
			}
			break;
		case 'c':
			i++;
			sscanf(argv[i], "%d",&BordingColor);
			break;
		case 'a':
			i++;
			sscanf(argv[i], "%lf",&LdMinEdge);
			AngleLimit = true;
			break;
		case 'd':
			switch (argv[i][2])
			{
			case 0:
				UnColor = true;
				break;
			case '+':
				UnColorAll=true;
				break;
			default:
				usage();
				return 1;
			}
			break;
		case 'm':
			ColoredStop = false;
			break;
		default:
			usage();
			return 1;
		}
	}
	if((UnColor || UnColorAll) && !Sorted) cout << "** No sorting specified, Uncolor option inactive! **";
	if(BordingColor==-1) BordingColor=KeyColor;
	Fldraw in;
	if(!in.ldLoad (argv[argc-2]))
	{
		cout << argv[argc-2] << " not found" << endl;
		pause();
		return 2;
	}

	if (Expand)
	{
		cout << "\nExpanding subfiles\n";
		cout << "LDraw subfiles search locations:\n" << path->toString().c_str() << endl;
		in.ldExpand(path);
		cout << endl;
	}

	if(ExpandKey) 
	{
		cout << "\nExpanding key color\n";
		in.colourNeighbour();
	}

	cout << "\nSelecting lines nearby key color\n";
	in.colourLines();
	if(Sorted) 
	{
		in.sortColor();
		if(UnColorAll) in.unColor();
	}
	if(!in.ldSave(argv[argc-1]))
	{
		cout <<" Can't create" << argv[argc-1] << endl;
		pause();
		return 2;
	}
	cout << CompPoint << " Point comparisons done" << endl;
	cout << NbrSelSurf << " Surface(s) selected" << endl;
	cout << NbrSelLine << " Line(s) selected" << endl;

	pause();
	return 0;
}

