#pragma warning( disable : 4786)
#ifndef HPP_LDRAW
#define HPP_LDRAW

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <math.h>
#include <cstring>
#include <string.h>
#include <vector>
#include <algorithm>

using namespace std;

#define Comment 0
#define Subfile 1
#define Line 2
#define Triangle 3
#define Quad 4
#define Condline 5
#define Empty 6

#define EPSILON 0.000001
#define PI acos(-1)

#define FLAT 0.1; // Small angle, no line generated
#define MAXCOND 60; // Condline generated below this angle
#define MINEDGE 60; // Edge line generated above this angle

// Global variables

#ifdef MAIN
double LdPrecision = EPSILON;
double LdFlat = FLAT;
double LdMaxCond = MAXCOND;
double LdMinEdge = MINEDGE;
bool DelCond = false;
bool DelEdge = false;
bool Expand = false;
bool Inlined = false;
bool OnlyUnmatched=false;
bool NoUnmatched=false;
bool SubComments = true;
bool DebugColors = false;
bool BFCed=false;
int CxCv=0;
int CompPoint=0;
int KeyColor=5;
int BordingColor=-1;
bool ExpandKey=true;
bool NoFrontier=false;
bool Sorted=false;
bool AngleLimit=false;
bool LoopLimit=false;
long MaxLoop;
long NbrSelSurf=0;
long NbrSelLine=0;
bool UnColor=false;
bool UnColorAll=false;
bool ColoredStop=true;
bool NoBording=false;


#else
extern double LdPrecision;
extern double LdFlat;
extern double LdMaxCond;
extern double LdMinEdge;
extern bool DelCond;
extern bool DelEdge;
extern bool Expand;
extern bool Inlined;
extern bool WriteNewOnly;
extern bool DebugColors;
extern bool BFCed;
extern int CxCv;
extern bool OnlyUnmatched;
extern bool NoUnmatched;
extern bool SubComments;
extern int CompPoint;
extern int KeyColor;
extern bool ExpandKey;
extern bool NoFrontier;
extern int BordingColor;
extern bool Sorted;
extern bool AngleLimit;
extern bool LoopLimit;
extern long MaxLoop;
extern long NbrSelSurf;
extern long NbrSelLine;
extern bool UnColor;
extern bool UnColorAll;
extern bool ColoredStop;
extern bool NoBording;

#endif

class Object
{
	virtual void printclassname()
	{
	}
};

class Point:public Object
{
public:

	// constructeurs
	Point();
	Point(const Point &p);
	Point(double x, double y, double z );

	//methodes
	double getx() { return m_x; }
	double gety() { return m_y; }
	double getz() { return m_z; }

	void setp (double xi, double yi, double zi);
	void setp (const Point &p);
	Point::addp(Point* p);
	char* pparse (char* str);
	double distance (Point &p=Point(0,0,0));
	bool compare(Point &p);
	void print(bool lf=true);
	string toString();
	void printclassname();
protected: // == Private except for derived class
	double m_x,m_y,m_z;

// declare comme friend pour pouvoir utiliser props et methodes privees
friend ostream& operator << (ostream&, Point&);
};

class Vector:public Point
{
public:
	
	// Vector derived from Point
	Vector(Point &p):Point(p)
	{
	}
	// Vector derived from Point
	Vector(double x, double y, double z ):Point(x,y,z)
	{
	}
	Vector(Point &p1, Point &p2);

	Vector* cross (Vector &v);
	double dot (Vector &v);
	double norm ();
	void normalize ();
};	



class Matrix:public Object
{
public:
	Matrix::Matrix();
	Matrix(Point &p1, Point &p2, Point &p3);
	Matrix(double a,double b,double c,double d,double e,double f,double g,double h,double i);
	string toString();
	Vector* Mult(Vector &v1);
	Matrix* MatMult(Matrix &m1);
	double MatDeterminant();

protected:
	double m_mat[3][3];
};

class LdObject:public Object
{
public:
	LdObject()
	{
		m_NoOut=false;	
	}
	virtual string toString()=0;
	virtual int getType()=0;

// return a pointer to the first line of an object
	virtual LdObject* getFirstLine()
	{
		return NULL;
	}

// return a pointer to the first line of an object
	virtual LdObject* getNextLine()
	{
		return NULL;
	}

	void SetNoOut(bool b) { m_NoOut=b; }
	bool GetNoOut() {	return m_NoOut; }

	void SetBFC(int i) {m_BFC=i;}
	int GetBFC() {return m_BFC;}

// return true if triangle or quad
	virtual bool isSurface() {return false;}
// return true if line or condline
	virtual bool isLine() {return false;}

	virtual void SetColor (int col)	{}
	virtual int getColor (void)	{return 0;}


// Translate to point p
	virtual translate(Point &p)
	{
	}
// Transform with matrix m
	virtual transform(Matrix &m)
	{
	}	

// return normal to a surface
	virtual Vector* getNormal()
	{
		return NULL;
	}

// return angle between two surfaces
	virtual double getAngle(LdObject &surf, LdObject &line)
	{
		return 0L;
	}

// return true if point matches one line end
	virtual bool matchPoint(Point &p1) { return false;}

// Change winding of a surface
	virtual void InvertWinding()
	{
		return;
	}

// return true if line found
	virtual bool matchLine(LdObject &line) {return false;}

// return surface vertex not end of line
	virtual Point* getOtherPoint (LdObject &line) {return NULL;}
private:
	bool m_NoOut;
	int m_BFC;
};

class LdComment:public LdObject
{
public:
	LdComment(const LdComment &ldc);
	LdComment(const string &str);
	LdComment(const char *str);
	
	string toString();
	inline int getType()
	{
		return Comment;
	}

	int readbfc();

private:
	string m_cs;
};

class LdSubfile:public LdObject
{
public:
	LdSubfile(const LdSubfile &lds);
	LdSubfile(const char *str);
	translate(Point &p);
	transform(Matrix &m);
	Point * getOrigin() {return &m_origin;}
	string getName() {return m_file;}
	Matrix * getMAtrix() {return &m_mat;}
	string toString();
	inline int getType()
	{
		return Subfile;
	}
	inline void SetColor (int col)
	{
		m_col = col;
	}
	int inline getColor (void)
	{
		return m_col;
	}

private:
	int m_col;
	Point m_origin;
	Matrix m_mat;
	string m_file;
};

class LdLine:public LdObject
{
public:
	LdLine(const char *str);
	LdLine(const Point &p1, const Point &p2, const int col=0);
	string toString();
	inline int getType()
	{
		return Line;
	}

	inline SetLineColor (int col)
	{
		m_col = col;
	}
	
	inline SetLinePoints (Point p1, Point p2)
	{
		m_p1 = p1;
		m_p2 = p2;
	}

	translate(Point &p);
	transform(Matrix &m);
	LdObject* getFirstLine();
	inline bool isLine() {return true;}
	bool matchLine(LdObject &line);
	Point * getP1() {return &m_p1;}
	Point * getP2() {return &m_p2;}
	bool matchPoint(Point &p1);
	inline void SetColor (int col)
	{
		m_col = col;
	}
	inline int getColor (void)
	{
		return m_col;
	}
	
private:
	int m_col;
	Point m_p1;
	Point m_p2;
};

class LdTriangle:public LdObject
{
public:
	LdTriangle(const char *str);
	LdTriangle(Point &p1, Point &p2, Point &p3, int col);
	string toString();
	inline int getType()
	{
		return Triangle;
	}
	translate(Point &p);
	transform(Matrix &m);
	LdObject* getFirstLine();
	LdObject* getNextLine();
	inline bool isSurface() {return true;}
	bool matchLine(LdObject &line);
	Vector* getNormal();
	double getAngle(LdObject &surf, LdObject &line);
	Point* getOtherPoint (LdObject &line);
	void InvertWinding();
	inline void SetColor (int col)
	{
		m_col = col;
	}
	inline int getColor (void)
	{
		return m_col;
	}
	
private:
	int m_col;
	Point m_p1;
	Point m_p2;
	Point m_p3;
	int m_edgecpt;
};

class LdQuad:public LdObject
{
public:
	LdQuad(const char *str);
	string toString();
	inline int getType()
	{
		return Quad;
	}
	translate(Point &p);
	transform(Matrix &m);
	LdObject* getFirstLine();
	LdObject* getNextLine();
	inline bool isSurface() {return true;}
	bool matchLine(LdObject &line);
	Vector* getNormal();
	double getAngle(LdObject &surf, LdObject &line);
	Point* getOtherPoint (LdObject &line);
	void InvertWinding();
	inline void SetColor (int col)
	{
		m_col = col;
	}
	inline int getColor (void)
	{
		return m_col;
	}

private:
	int m_col;
	Point m_p1;
	Point m_p2;
	Point m_p3;
	Point m_p4;
	int m_edgecpt;
};

class LdCondline:public LdObject
{
public:
	LdCondline(const char *str);
	LdCondline(Point &p1, Point &p2, Point &p3, Point &p4, const int col=0);
	string toString();
	inline int getType()
	{
		return Condline;
	}
	translate(Point &p);
	transform(Matrix &m);
	LdObject* getFirstLine();
	inline bool isLine() {return true;}
	bool matchLine(LdObject &line);
	// return angle between normals of planes defined by each control point and line
	double getAngle();
	inline void SetColor (int col)
	{
		m_col = col;
	}
	inline int getColor (void)
	{
		return m_col;
	}

private:
	int m_col;
	Point m_p1;
	Point m_p2;
	Point m_p3;
	Point m_p4;
};

class LdEmpty:public LdObject
{
	string toString()
	{
		return "";
	}
	int getType()
	{
		return Empty;
	}
};

static void funcdelete (LdObject* ldo); 


class LdPath
{
public:
	LdPath();
	~LdPath();
	addPath(string &s);
	bool subOpen(ifstream &ldSubfile, string &subfilename);
	string toString();
private:
	vector <string*> pathtable;
};


class Fldraw:public LdObject
{

public:

	Fldraw()
	{
	}


	~Fldraw();

/*
//		if(ldtab != NULL) 
		{
			for(int i=0; i<ldtab.size() ; i++)
			{
				if(ldtab[i]!= NULL) delete ldtab[i];
			}
//			delete ldtab;

		}
*/
	

	string toString() { return NULL; }
	inline int getType()
	{
		return -1;
	}


// Method to load ldraw file
	bool ldLoad (char *fname);
// Method to save ldraw file
	bool ldSave (char *fname);
// Expand subfiles
	ldExpand(LdPath *path);
// Method to scan array and insert lines on non-matching edges
	findOrphan();
// Method to scan array and insert lines/condlines on adjacent surfaces
	findAdjacent();
// Propagate key color
	colourNeighbour();
// color lines according to nearby surfaces
	colourLines();
// Sort with key colors to end
	sortColor();
// Uncolor all elements of a LDraw file
	unColor();
private:
	// Ldraw object array of pointers
//	LdObject **ldtab;
	vector <LdObject*> ldtab;
	unsigned int m_nLine; // Initial line number
//	int m_nextLine; // Insertion point in array
//	int m_maxLine; // Array end;
};


#endif
