#!/bin/sh
 set -x

# to build a common usable intel 80386 compatible binary with some versions of
# gcc, you may want to set something like the following environment variables:

export CFLAGS=-march-i386
export CXXFLAGS=-march-i386

RPM_SRC_LIST="rpm RPM redhat packages"

unset MKRPM_SRC
for i in $RPM_SRC_LIST ; do 
   if test -d /usr/src/$i/SOURCES ; then
      MKRPM_SRC=/usr/src/$i/SOURCES
   fi
done
if test "$MKRPM_SRC" = "" ; then
   echo -n non of typical rpm source directories 1>&2
   for i in $RPM_SRC_LIST ; do 
       echo -n " " /usr/src/$i/SOURCES 1>&2 
   done
   echo " " found 1>&2 
   echo extend variable RPM_SRC_LIST in $0 for your system 1>&2
   exit 1
fi

UNAME_A=`uname -a`
UNAME_PS2="Linux $USER 2.2.1 #1 Wed Nov 14 18:28:00 JST 2001 mips unknown"
rm -rf /tmp/coverer && rm -rf /tmp/coverer-1.0 &&
(cd .. && tar -cpf - coverer) | (cd /tmp/ && tar -xvf -) &&
mv /tmp/coverer /tmp/coverer-1.0 && (cd /tmp/ && tar -cpf - coverer-1.0) | \
gzip -c > $MKRPM_SRC/coverer-1.0.tar.gz

if test "$UNAME_A"="$UNAME_PS2"; then
   export CFLAGS=
   export CXXFLAGS=
   # disable optimization on Playstation 2 cause of compiler bugs
   OPTIMIZE=""
   RPM_OPT_FLAGS=""
else 
   OPTIMIZE=--with-optimization
   RPM_OPT_FLAGS='$RPM_OPT_FLAGS'
fi

RPM_BUILD_ROOT='$RPM_BUILD_ROOT'

rm -f /tmp/coverer.spec
cat > /tmp/coverer.spec << EOT 
Summary: LDraw sheet generator
Name: coverer
Version: 1.0
Release: 1
#Copyright: ???
License: Copyright Philippe "Philo" Hurbain - 2007, Tomas Mller, Copyright 2001, softSurfer
Group: Applications/Multimedia
Source: $MKRPM_SRC/coverer-1.0.tar.gz 
BuildRoot: /var/tmp/%{name}-buildroot

%description
Coverer utility creates a sheet of triangle and quads between two sets of 
lines. Each set is provided to the utility as separate LDraw files. 
A third file containing the surface (and its conditional lines) is created.
It is a simple console application.
See http://www.philohome.com/isecalc/coverer.htm
%prep
%setup -q

%build
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS" 

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/share/misc/coverer
mkdir -p $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples

install -s -m 755 Linux_i386/coverer $RPM_BUILD_ROOT/usr/bin/coverer
install -m 644 'Documentation/Coverer, LDraw sheet generator.pdf' $RPM_BUILD_ROOT/usr/share/misc/coverer/Coverer_LDraw_sheet_generator.pdf
install -m 644 Examples/adapt1621.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/adapt1621.dat
install -m 644 Examples/arc-out.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/arc-out.dat
install -m 644 Examples/arc-r-out.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/arc-r-out.dat
install -m 644 Examples/arc-rok-out.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/arc-rok-out.dat
install -m 644 Examples/arc1.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/arc1.dat
install -m 644 Examples/arc2-r.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/arc2-r.dat
install -m 644 Examples/arc2.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/arc2.dat
install -m 644 Examples/cir16.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/cir16.dat
install -m 644 Examples/cir21.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/cir21.dat
install -m 644 Examples/sqc-45-out.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/sqc-45-out.dat
install -m 644 Examples/sqc-out.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/sqc-out.dat
install -m 644 Examples/sqc1.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/sqc1.dat
install -m 644 Examples/sqc2-45.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/sqc2-45.dat
install -m 644 Examples/sqc2.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/sqc2.dat
install -m 644 Examples/wedge-l-out.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/wedge-l-out.dat
install -m 644 Examples/wedge-out.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/wedge-out.dat
install -m 644 Examples/wedge1.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/wedge1.dat
install -m 644 Examples/wedge2.dat $RPM_BUILD_ROOT/usr/share/misc/coverer/Examples/wedge2.dat

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)

/usr/bin/coverer
/usr/share/misc/coverer/Coverer_LDraw_sheet_generator.pdf
/usr/share/misc/coverer/Examples/*
EOT

lsb-rpm -ba /tmp/coverer.spec

